/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzacraft.recipes.mortar;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.tiviacz.pizzacraft.recipes.mortar.MortarRecipe;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;

public class MortarRecipeSerializer
implements RecipeSerializer<MortarRecipe> {
    public static final MortarRecipeSerializer INSTANCE = new MortarRecipeSerializer();
    public static final ResourceLocation ID = new ResourceLocation("pizzacraft", "mortar_recipe");

    public MortarRecipe fromJson(ResourceLocation id, JsonObject json) {
        int duration = GsonHelper.m_13824_((JsonObject)json, (String)"duration", (int)20);
        NonNullList<Ingredient> nonnulllist = MortarRecipeSerializer.readIngredients(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
        if (nonnulllist.isEmpty()) {
            throw new JsonParseException("No ingredients for shapeless recipe");
        }
        if (nonnulllist.size() > 4) {
            throw new JsonParseException("Too many ingredients for shapeless recipe the max is 4");
        }
        ItemStack itemstack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
        return new MortarRecipe(nonnulllist, itemstack, duration, id);
    }

    @Nullable
    public MortarRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
        int d = buffer.readInt();
        int i = buffer.m_130242_();
        NonNullList nonnulllist = NonNullList.m_122780_((int)i, (Object)Ingredient.f_43901_);
        for (int j = 0; j < nonnulllist.size(); ++j) {
            nonnulllist.set(j, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
        }
        ItemStack itemstack = buffer.m_130267_();
        return new MortarRecipe((NonNullList<Ingredient>)nonnulllist, itemstack, d, id);
    }

    private static NonNullList<Ingredient> readIngredients(JsonArray ingredientArray) {
        NonNullList nonnulllist = NonNullList.m_122779_();
        for (int i = 0; i < ingredientArray.size(); ++i) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)ingredientArray.get(i));
            if (ingredient.m_43947_()) continue;
            nonnulllist.add((Object)ingredient);
        }
        return nonnulllist;
    }

    public void toNetwork(FriendlyByteBuf buffer, MortarRecipe recipe) {
        buffer.writeInt(recipe.getDuration());
        buffer.m_130130_(recipe.getInputs().size());
        for (Ingredient ingredient : recipe.getInputs()) {
            ingredient.m_43923_(buffer);
        }
        buffer.m_130055_(recipe.m_8043_());
    }
}

